program Space;
uses
  Windows,
  Messages,
  Controls,
  Graphics,
  Dialogs,
  SysUtils,
  ddraw,bass;

const
  WND_CLASS = 'Main Window';
  WND_STYLE =  LongWord($80000000);
  RDX_TITLE = 'Space.exe';
  PointsCount = 1000;    //  -  
  D = 1000;
  MenuSound = 'music.mp3';



type
  TPoint3D = record
    X: Real;
    Y: Real;
    Z: Real;
  end;

var
Speed       :integer = 5;      //     
VGA:boolean = False;
INSTANCE    : hwnd;
HWND_FORM   : hwnd;
WND_TITLE   : String;
HWND_WIDTH  : integer = 640;
HWND_HEIGHT : integer = 480;
HWND_BITS   : integer = 32;
HWND_POS_X  : integer = 0;
HWND_POS_Y  : integer = 0;
  cx : integer;
  cy : integer;
DC                 : LongWord;
DDRESULT           : hresult;
DDrawObject        : IDirectDraw;                 //    !!!    .
PrimarySurface     : IDirectDrawSurface;       //  
SecondarySurface   : IDirectDrawSurface;     //  
SurfaceDescription : TDDSurfaceDesc;
BackCaps           : TDDSCaps;                       //  , 
streamGame_loadsong : Dword;
FullScreen:Boolean;

    oX: Integer;
    oY: Integer;
    rPoint: Integer;         //  
    Points3D: array[1..PointsCount] of TPoint3D; //   
Fone:TBitmap;
Foneload:Boolean;
StereoScope:integer;
ShowTitle:Boolean;


function Rect(Left, Top, Right, Bottom: Integer): TRect;
begin
  Result.Left := Left;
  Result.Top := Top;
  Result.Bottom := Bottom;
  Result.Right := Right;
end;

Procedure DdrawFree;
Begin
SecondarySurface._Release;
pointer(SecondarySurface):=nil;
PrimarySurface._Release;
pointer(PrimarySurface):=nil;
DDrawObject._Release;
pointer(DDrawObject):=nil;
End;


Procedure InitializeStars;
var
  I: Integer;
begin
  //   

  oX := HWND_Width  div 2;
  oY := HWND_Height div 2;
  Randomize;
  for I := 1 to PointsCount do
  begin
    Points3D[I].X := Random(HWND_Width)  - oX;
    Points3D[I].Y := Random(HWND_Height) - oY;
    Points3D[I].Z := -Random(D);
  end;

end;

procedure FreeAll;
begin
DdrawFree;
PostQuitMessage(0);
Halt;
end;

Procedure DdrawInitialized;
Begin
DDResult := DirectDrawCreate (nil,DDrawObject,nil);
if FullScreen then begin
DDResult := DDrawObject.SetCooperativeLevel (HWND_FORM, DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN);
DDResult := DDrawObject.SetDisplayMode (HWND_WIDTH,HWND_HEIGHT,HWND_BITS);
with SurfaceDescription do begin
	dwSize            := sizeof(SurfaceDescription);
	dwFlags           := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
  ddsCaps.dwCaps    := DDSCAPS_PRIMARYSURFACE or DDSCAPS_FLIP or DDSCAPS_COMPLEX;
  DwBackBufferCount := 1;
end;
DDResult        := DDrawObject.CreateSurface (SurfaceDescription,PrimarySurface,nil);
BackCaps.dwCaps := DDSCAPS_BACKBUFFER;
PrimarySurface.GetAttachedSurface (BackCaps,SecondarySurface);
end else begin
// 
end;
End;


Procedure DrawSurfaces;
var
 DDCanvas: TCanvas;
 LBXcolor,RBXcolor:TColor;
 F:Integer;
  Sum: Real;
  X: Integer;
  Y: Integer;
  I: Integer;
begin
DDCanvas := TCanvas.Create;
try
   if SecondarySurface.GetDC(DC) = HResult(0) then
    try
      with DDCanvas do
      begin
      Handle := dc; // make the canvas output to the DC
      Brush.Color := clBlack;
      FillRect(Rect(0, 0, HWND_WIDTH, HWND_HEIGHT));
      if Foneload then Draw(0,0,Fone);

 for I := 1 to PointsCount do
 begin
      Points3D[I].Z := Points3D[I].Z - Speed;
      if Points3D[I].Z < - D then BEGIN
      Points3D[I].Z := 0;
      Points3D[I].X := Random(HWND_Width)  - oX;
      Points3D[I].Y := Random(HWND_Height) - oY;
      END;
      {------     3D  2D! ------}
      if POINTS3D[I].Z + D = 0 then POINTS3D[I].Z := 0.1;
      SUM := D / (POINTS3D[I].Z + D);
      X := OX + ROUND(POINTS3D[I].X * SUM);
      Y := OY + ROUND(POINTS3D[I].Y * SUM);

      {-------------------------------------------------------------}


rPoint := -Round(Points3D[I].Z * 0.005);
if rPoint<2 then rPoint:=2;


F:=ABS(round(Points3D[I].Z * 0.255));
If StereoScope<2 then begin
if StereoScope=0 then LBxcolor:=RGB(0,0,f) else LBxcolor:=RGB(0,f,f);
RBxcolor:=RGB(f,0,0);
CX:= -Round(((D*0.7) + Points3D[I].Z) / 30);
Pen.Color:=RBxcolor;
Pen.Mode:=pmMerge ;
Brush.Color := RBxcolor;
     Ellipse(X+cx , Y+cy, X + rPoint +cx, Y + rPoint + cy);
Pen.Color:=LBXcolor;
Pen.Mode:=pmMerge ;
Brush.Color := LBXcolor;
     Ellipse(X-cx, Y-cy, X + rPoint -cx, Y + rPoint - cy);
 end else begin
 LBxcolor:=RGB(f,f,f);
 Pen.Color:=LBXcolor;
Pen.Mode:=pmMerge ;
Brush.Color := LBXcolor;
     Ellipse(X, Y, X + rPoint, Y + rPoint);
 end;
end;

if ShowTitle then begin

        Brush.Style := bsClear; // transparent text background
        Font.Name := 'Tahoma';
        Font.Color := RGB(0,255,0);
        Font.Size := 24;
TextOUT(HWND_WIDTH div 2 - 150, HWND_HEIGHT div 2 - 30 , 'S C R A T O R S   C O M');
TextOUT(HWND_WIDTH div 2 - 150, HWND_HEIGHT div 2 , '3 D   T E H N O L O G Y');
    end;
      end;

    finally
     SecondarySurface.ReleaseDC(DC);
     PrimarySurface.Flip(nil, DDFLIP_WAIT);
    end;
 finally
    DDCanvas.Free;
end;
end;

procedure Restore;
begin
if IsIconic(HWND_FORM) then
  begin
    SetActiveWindow(HWND_FORM);
    DefWindowProc(HWND_FORM, WM_SYSCOMMAND, SC_RESTORE, 0);
  end;
  PrimarySurface.Restore;
  SecondarySurface.Restore;
  DdrawFree;
  DdrawInitialized;
  DrawSurfaces;
end;

function WindowProc (hwnd, msg: longWORD; wParam, lParam: Integer): longint; stdcall;
begin
result:=0;
case Msg of
  WM_CREATE : HWND_FORM := hwnd;
  WM_KEYDOWN: case wParam of
              vk_f3: begin
                     inc(Stereoscope);
                     if Stereoscope=3 then Stereoscope:=0;

                     end;
              vk_f1: ShowTitle:= not ShowTitle;
              vk_f4: begin
              FullScreen:=not FullScreen;
              {DdrawFree;
              DdrawInitialized;  }
              end;
              vk_escape: FreeAll;
              VK_ADD: speed:=speed+1;
              VK_SUBTRACT: if speed>1 then speed:=speed-1;
              end;
  WM_CLOSE  : Freeall;
  WM_DESTROY : Freeall;
  WM_KILLFOCUS: {};
  WM_SYSCOMMAND:
          case WParam and $FFF0 of
            SC_RESTORE: restore;
            SC_CLOSE:   Freeall;
          end;

 else Result := defwindowproc(hwnd,msg,wParam,lParam);
end;
end;

function CreateMainWindow: Boolean;stdcall;
var
  wnd : TWndClass;
begin
ZeroMemory(@wnd, SizeOf(wnd));
INSTANCE :=GetModuleHandle(nil);
if MessageDLG('   ? ( - 640480)',
   mtConfirmation,[mbYes,mbNo],0) = mrYes then begin
   HWND_WIDTH:=GetSystemMetrics(SM_CXSCREEN);
   HWND_HEIGHT:=GetSystemMetrics(SM_CYSCREEN);
   end;
with wnd do
  begin
    style         := LongWord(2) or LongWord(1);
    lpfnWndProc   := @windowproc;
    Hinstance     := INSTANCE ;
    hbrBackground := 0;
    lpszClassName := WND_CLASS;
    hCursor       := LoadCursor(0, PAnsiChar(32512));
    HIcon         := LoadIcon(Hinstance, 'MainIcon');
  end;
Result := (RegisterClass(wnd) <> 0) and
          (CreateWindowEx(0,
                         WND_CLASS,
                         PChar(WND_TITLE),
                         WND_STYLE,
                         HWND_POS_X,
                         HWND_POS_Y,
                         HWND_WIDTH,
                         HWND_HEIGHT,
                         0, 0, INSTANCE, nil) <> 0);
ShowCursor(false);
ShowWindow(HWND_FORM, 5);
UpdateWindow (HWND_FORM);
Foneload:=FileExists('fone.bmp');
StereoScope:=0;
ShowTitle:=False;
FullScreen:=True;
If Foneload then begin
Fone:=TBitmap.Create;
Fone.LoadFromFile('fone.bmp');
end;
Bass_Init(-1,44100,0,0,nil);
streamGame_loadsong:=BASS_StreamCreateFile(False, Pchar(MenuSound), 0, 0, 0);
BASS_ChannelSetAttributes(streamGame_loadsong,44100,100,0);
Bass_ChannelPlay(streamGame_loadsong,True);

DdrawInitialized;
InitializeStars;
end;

function WinMain : Integer; stdcall;
var Msg : TMsg;
    Finished : Boolean;
begin
 Finished := False;
 while not Finished do
  begin
   if PeekMessage(Msg, 0, 0, 0, PM_REMOVE) then
    begin
     if Msg.Message = WM_QUIT then Finished := True
     else
      begin
       TranslateMessage(msg);
       DispatchMessage(msg);
      end;
    end
   else
    begin
     DrawSurfaces;
     end;
  end;

 Result := Msg.wParam;
end;


procedure DestroyTheWindow;
begin
 ShowCursor(true);
 DestroyWindow(HWND_FORM);
 UnRegisterClass(WND_CLASS, hInstance);
end;

begin
if CreateMainWindow then begin
WinMain;
DestroyTheWindow;
end
else //       -  
    MessageBox(0, '   ', '',  $00000010);
end.


