unit DDraw;

interface

{$Z4}
{$A+}
{ $WEAKPACKAGEUNIT}

uses Windows;


const
  DD_ROP_SPACE = 256 div 32;       // space required to store ROP array

  MAX_DDDEVICEID_STRING = 512;

{ DirectDraw Structures }

type
  IDirectDraw = interface;
  IDirectDrawSurface = interface;
  IDirectDrawPalette = interface;
  IDirectDrawClipper = interface;
  IDirectDrawColorControl = interface;
  IDirectDrawGammaControl = interface;


{ TDDColorKey structure }

  PDDColorKey = ^TDDColorKey;
  TDDColorKey = record
    dwColorSpaceLowValue: DWORD;   // low boundary of color space that is to
                                   //  be treated as Color Key, inclusive
    dwColorSpaceHighValue: DWORD;  // high boundary of color space that is
                                   //  to be treated as Color Key, inclusive
  end;

  DDCOLORKEY = TDDColorKey;
  LPDDCOLORKEY = PDDColorKey;

{ TDDBltFX structure }

  PDDBltFX = ^TDDBltFX;
  TDDBltFX = record
    dwSize: DWORD;                           // size of structure
    dwDDFX: DWORD;                           // FX operations
    dwROP: DWORD;                            // Win32 raster operations
    dwDDROP: DWORD;                          // Raster operations new for DirectDraw
    dwRotationAngle: DWORD;                  // Rotation angle for blt
    dwZBufferOpCode: DWORD;                  // ZBuffer compares
    dwZBufferLow: DWORD;                     // Low limit of Z buffer
    dwZBufferHigh: DWORD;                    // High limit of Z buffer
    dwZBufferBaseDest: DWORD;                // Destination base value
    dwZDestConstBitDepth: DWORD;             // Bit depth used to specify Z constant for destination
    case Integer of
    0: (
      dwZDestConst: DWORD;                   // Constant to use as Z buffer for dest
      dwZSrcConstBitDepth: DWORD;            // Bit depth used to specify Z constant for source
      dwZSrcConst: DWORD;                    // Constant to use as Z buffer for src
      dwAlphaEdgeBlendBitDepth: DWORD;       // Bit depth used to specify constant for alpha edge blend
      dwAlphaEdgeBlend: DWORD;               // Alpha for edge blending
      dwReserved: DWORD;
      dwAlphaDestConstBitDepth: DWORD;       // Bit depth used to specify alpha constant for destination
      dwAlphaDestConst: DWORD;               // Constant to use as Alpha Channel
      dwAlphaSrcConstBitDepth: DWORD;        // Bit depth used to specify alpha constant for source
      dwAlphaSrcConst: DWORD;                // Constant to use as Alpha Channel
      dwFillColor: DWORD;                    // color in RGB or Palettized
      ddckDestColorkey: TDDColorKey;          // DestColorkey override
      ddckSrcColorkey: TDDColorKey;           // SrcColorkey override
      );
    1: (
      lpDDSZBufferDest: Pointer{IDirectDrawSurface};  // Surface to use as Z buffer for dest
      _union1b: DWORD;
      lpDDSZBufferSrc: Pointer{IDirectDrawSurface};   // Surface to use as Z buffer for src
      _union1d: DWORD;
      _union1e: DWORD;
      _union1f: DWORD;
      _union1g: DWORD;
      lpDDSAlphaDest: Pointer{IDirectDrawSurface};    // Surface to use as Alpha Channel
      _union1i: DWORD;
      lpDDSAlphaSrc: Pointer{IDirectDrawSurface};     // Surface to use as Alpha Channel
      dwFillDepth: DWORD;                    // depth value for z-buffer
      );
    2: (
      _union2a: DWORD;
      _union2b: DWORD;
      _union2c: DWORD;
      _union2d: DWORD;
      _union2e: DWORD;
      _union2f: DWORD;
      _union2g: DWORD;
      _union2h: DWORD;
      _union2i: DWORD;
      _union2j: DWORD;
      lpDDSPattern: Pointer{IDirectDrawSurface};       // Surface to use as pattern
      );
  end;

  DDBLTFX = TDDBltFX;
  LPDDBLTFX = PDDBltFX;

{ TDDSCaps structure }

  PDDSCaps = ^TDDSCaps;
  TDDSCaps = record
    dwCaps: DWORD;         // capabilities of surface wanted
  end;

  DDSCAPS = TDDSCaps;
  LPDDSCAPS = PDDSCaps;
{ TDDOSCaps structure }

  PDDOSCaps = ^TDDOSCaps;
  TDDOSCaps = record
    dwCaps: DWORD;         // capabilities of surface wanted
  end;

  DDOSCAPS = TDDOSCaps;
  LPDDOSCAPS = PDDOSCaps;


{ TDDSCapsEx structure }

  PDDSCapsEx = ^TDDSCapsEx;
  TDDSCapsEx = record
    dwCaps2: DWORD;
    dwCaps3: DWORD;
    dwCaps4: DWORD;
  end;

  DDSCAPSEX = TDDSCapsEx;
  LPDDSCAPSEX = PDDSCapsEx;

{ TDDSCaps2 structure }

  PDDSCaps2 = ^TDDSCaps2;
  TDDSCaps2 = record
    dwCaps: DWORD;         // capabilities of surface wanted
    dwCaps2: DWORD;
    dwCaps3: DWORD;
    dwCaps4: DWORD;
  end;

  DDSCAPS2 = TDDSCaps2;
  LPDDSCAPS2 = PDDSCaps2;

{ TDDCaps structure }

  PDDCaps_DX1 = ^TDDCaps_DX1;
  TDDCaps_DX1 = record
    dwSize: DWORD;                 // size of the DDDRIVERCAPS structure
    dwCaps: DWORD;                 // driver specific capabilities
    dwCaps2: DWORD;                // more driver specific capabilites
    dwCKeyCaps: DWORD;             // color key capabilities of the surface
    dwFXCaps: DWORD;               // driver specific stretching and effects capabilites
    dwFXAlphaCaps: DWORD;          // alpha driver specific capabilities
    dwPalCaps: DWORD;              // palette capabilities
    dwSVCaps: DWORD;               // stereo vision capabilities
    dwAlphaBltConstBitDepths: DWORD;       // DDBD_2,4,8
    dwAlphaBltPixelBitDepths: DWORD;       // DDBD_1,2,4,8
    dwAlphaBltSurfaceBitDepths: DWORD;     // DDBD_1,2,4,8
    dwAlphaOverlayConstBitDepths: DWORD;   // DDBD_2,4,8
    dwAlphaOverlayPixelBitDepths: DWORD;   // DDBD_1,2,4,8
    dwAlphaOverlaySurfaceBitDepths: DWORD; // DDBD_1,2,4,8
    dwZBufferBitDepths: DWORD;             // DDBD_8,16,24,32
    dwVidMemTotal: DWORD;          // total amount of video memory
    dwVidMemFree: DWORD;           // amount of free video memory
    dwMaxVisibleOverlays: DWORD;   // maximum number of visible overlays
    dwCurrVisibleOverlays: DWORD;  // current number of visible overlays
    dwNumFourCCCodes: DWORD;       // number of four cc codes
    dwAlignBoundarySrc: DWORD;     // source rectangle alignment
    dwAlignSizeSrc: DWORD;         // source rectangle byte size
    dwAlignBoundaryDest: DWORD;    // dest rectangle alignment
    dwAlignSizeDest: DWORD;        // dest rectangle byte size
    dwAlignStrideAlign: DWORD;     // stride alignment
    dwRops: array[0..DD_ROP_SPACE-1] of DWORD;   // ROPS supported
    ddsCaps: TDDSCaps;             // TDDSCaps structure has all the general capabilities
    dwMinOverlayStretch: DWORD;    // minimum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxOverlayStretch: DWORD;    // maximum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinLiveVideoStretch: DWORD;  // minimum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxLiveVideoStretch: DWORD;  // maximum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinHwCodecStretch: DWORD;    // minimum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxHwCodecStretch: DWORD;    // maximum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwReserved1: DWORD;            // reserved
    dwReserved2: DWORD;            // reserved
    dwReserved3: DWORD;            // reserved
  end;

  PDDCaps_DX3 = ^TDDCaps_DX3;
  TDDCaps_DX3 = record
    dwSize: DWORD;                 // size of the DDDRIVERCAPS structure
    dwCaps: DWORD;                 // driver specific capabilities
    dwCaps2: DWORD;                // more driver specific capabilites
    dwCKeyCaps: DWORD;             // color key capabilities of the surface
    dwFXCaps: DWORD;               // driver specific stretching and effects capabilites
    dwFXAlphaCaps: DWORD;          // alpha driver specific capabilities
    dwPalCaps: DWORD;              // palette capabilities
    dwSVCaps: DWORD;               // stereo vision capabilities
    dwAlphaBltConstBitDepths: DWORD;       // DDBD_2,4,8
    dwAlphaBltPixelBitDepths: DWORD;       // DDBD_1,2,4,8
    dwAlphaBltSurfaceBitDepths: DWORD;     // DDBD_1,2,4,8
    dwAlphaOverlayConstBitDepths: DWORD;   // DDBD_2,4,8
    dwAlphaOverlayPixelBitDepths: DWORD;   // DDBD_1,2,4,8
    dwAlphaOverlaySurfaceBitDepths: DWORD; // DDBD_1,2,4,8
    dwZBufferBitDepths: DWORD;             // DDBD_8,16,24,32
    dwVidMemTotal: DWORD;          // total amount of video memory
    dwVidMemFree: DWORD;           // amount of free video memory
    dwMaxVisibleOverlays: DWORD;   // maximum number of visible overlays
    dwCurrVisibleOverlays: DWORD;  // current number of visible overlays
    dwNumFourCCCodes: DWORD;       // number of four cc codes
    dwAlignBoundarySrc: DWORD;     // source rectangle alignment
    dwAlignSizeSrc: DWORD;         // source rectangle byte size
    dwAlignBoundaryDest: DWORD;    // dest rectangle alignment
    dwAlignSizeDest: DWORD;        // dest rectangle byte size
    dwAlignStrideAlign: DWORD;     // stride alignment
    dwRops: array[0..DD_ROP_SPACE-1] of DWORD;   // ROPS supported
    ddsCaps: TDDSCaps;             // TDDSCaps structure has all the general capabilities
    dwMinOverlayStretch: DWORD;    // minimum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxOverlayStretch: DWORD;    // maximum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinLiveVideoStretch: DWORD;  // minimum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxLiveVideoStretch: DWORD;  // maximum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinHwCodecStretch: DWORD;    // minimum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxHwCodecStretch: DWORD;    // maximum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwReserved1: DWORD;            // reserved
    dwReserved2: DWORD;            // reserved
    dwReserved3: DWORD;            // reserved
    dwSVBCaps: DWORD;              // driver specific capabilities for System->Vmem blts
    dwSVBCKeyCaps: DWORD;          // driver color key capabilities for System->Vmem blts
    dwSVBFXCaps: DWORD;            // driver FX capabilities for System->Vmem blts
    dwSVBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->Vmem blts
    dwVSBCaps: DWORD;              // driver specific capabilities for Vmem->System blts
    dwVSBCKeyCaps: DWORD;          // driver color key capabilities for Vmem->System blts
    dwVSBFXCaps: DWORD;            // driver FX capabilities for Vmem->System blts
    dwVSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for Vmem->System blts
    dwSSBCaps: DWORD;              // driver specific capabilities for System->System blts
    dwSSBCKeyCaps: DWORD;          // driver color key capabilities for System->System blts
    dwSSBFXCaps: DWORD;            // driver FX capabilities for System->System blts
    dwSSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->System blts
    dwReserved4: DWORD;            // reserved
    dwReserved5: DWORD;            // reserved
    dwReserved6: DWORD;            // reserved
  end;

  PDDCaps_DX5 = ^TDDCaps_DX5;
  TDDCaps_DX5 = record
    dwSize: DWORD;                 // size of the DDDRIVERCAPS structure
    dwCaps: DWORD;                 // driver specific capabilities
    dwCaps2: DWORD;                // more driver specific capabilites
    dwCKeyCaps: DWORD;             // color key capabilities of the surface
    dwFXCaps: DWORD;               // driver specific stretching and effects capabilites
    dwFXAlphaCaps: DWORD;          // alpha driver specific capabilities
    dwPalCaps: DWORD;              // palette capabilities
    dwSVCaps: DWORD;               // stereo vision capabilities
    dwAlphaBltConstBitDepths: DWORD;       // DDBD_2,4,8
    dwAlphaBltPixelBitDepths: DWORD;       // DDBD_1,2,4,8
    dwAlphaBltSurfaceBitDepths: DWORD;     // DDBD_1,2,4,8
    dwAlphaOverlayConstBitDepths: DWORD;   // DDBD_2,4,8
    dwAlphaOverlayPixelBitDepths: DWORD;   // DDBD_1,2,4,8
    dwAlphaOverlaySurfaceBitDepths: DWORD; // DDBD_1,2,4,8
    dwZBufferBitDepths: DWORD;             // DDBD_8,16,24,32
    dwVidMemTotal: DWORD;          // total amount of video memory
    dwVidMemFree: DWORD;           // amount of free video memory
    dwMaxVisibleOverlays: DWORD;   // maximum number of visible overlays
    dwCurrVisibleOverlays: DWORD;  // current number of visible overlays
    dwNumFourCCCodes: DWORD;       // number of four cc codes
    dwAlignBoundarySrc: DWORD;     // source rectangle alignment
    dwAlignSizeSrc: DWORD;         // source rectangle byte size
    dwAlignBoundaryDest: DWORD;    // dest rectangle alignment
    dwAlignSizeDest: DWORD;        // dest rectangle byte size
    dwAlignStrideAlign: DWORD;     // stride alignment
    dwRops: array[0..DD_ROP_SPACE-1] of DWORD;   // ROPS supported
    ddsCaps: TDDSCaps;             // TDDSCaps structure has all the general capabilities
    dwMinOverlayStretch: DWORD;    // minimum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxOverlayStretch: DWORD;    // maximum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinLiveVideoStretch: DWORD;  // minimum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxLiveVideoStretch: DWORD;  // maximum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinHwCodecStretch: DWORD;    // minimum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxHwCodecStretch: DWORD;    // maximum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwReserved1: DWORD;            // reserved
    dwReserved2: DWORD;            // reserved
    dwReserved3: DWORD;            // reserved
    dwSVBCaps: DWORD;              // driver specific capabilities for System->Vmem blts
    dwSVBCKeyCaps: DWORD;          // driver color key capabilities for System->Vmem blts
    dwSVBFXCaps: DWORD;            // driver FX capabilities for System->Vmem blts
    dwSVBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->Vmem blts
    dwVSBCaps: DWORD;              // driver specific capabilities for Vmem->System blts
    dwVSBCKeyCaps: DWORD;          // driver color key capabilities for Vmem->System blts
    dwVSBFXCaps: DWORD;            // driver FX capabilities for Vmem->System blts
    dwVSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for Vmem->System blts
    dwSSBCaps: DWORD;              // driver specific capabilities for System->System blts
    dwSSBCKeyCaps: DWORD;          // driver color key capabilities for System->System blts
    dwSSBFXCaps: DWORD;            // driver FX capabilities for System->System blts
    dwSSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->System blts
    { Members added for DX5 }
    dwMaxVideoPorts: DWORD;        // maximum number of usable video ports
    dwCurrVideoPorts: DWORD;       // current number of video ports used
    dwSVBCaps2: DWORD;             // more driver specific capabilities for System->Vmem blts
    dwNLVBCaps: DWORD;             // driver specific capabilities for non-local->local vidmem blts
    dwNLVBCaps2: DWORD;            // more driver specific capabilities non-local->local vidmem blts
    dwNLVBCKeyCaps: DWORD;         // driver color key capabilities for non-local->local vidmem blts
    dwNLVBFXCaps: DWORD;           // driver FX capabilities for non-local->local blts
    dwNLVBRops: array[0..DD_ROP_SPACE-1] of DWORD; // ROPS supported for non-local->local blts
  end;

  PDDCaps_DX6 = ^TDDCaps_DX6;
  TDDCaps_DX6 = record
    dwSize: DWORD;                 // size of the DDDRIVERCAPS structure
    dwCaps: DWORD;                 // driver specific capabilities
    dwCaps2: DWORD;                // more driver specific capabilites
    dwCKeyCaps: DWORD;             // color key capabilities of the surface
    dwFXCaps: DWORD;               // driver specific stretching and effects capabilites
    dwFXAlphaCaps: DWORD;          // alpha caps
    dwPalCaps: DWORD;              // palette capabilities
    dwSVCaps: DWORD;               // stereo vision capabilities
    dwAlphaBltConstBitDepths: DWORD;       // DDBD_2,4,8
    dwAlphaBltPixelBitDepths: DWORD;       // DDBD_1,2,4,8
    dwAlphaBltSurfaceBitDepths: DWORD;     // DDBD_1,2,4,8
    dwAlphaOverlayConstBitDepths: DWORD;   // DDBD_2,4,8
    dwAlphaOverlayPixelBitDepths: DWORD;   // DDBD_1,2,4,8
    dwAlphaOverlaySurfaceBitDepths: DWORD; // DDBD_1,2,4,8
    dwZBufferBitDepths: DWORD;             // DDBD_8,16,24,32
    dwVidMemTotal: DWORD;          // total amount of video memory
    dwVidMemFree: DWORD;           // amount of free video memory
    dwMaxVisibleOverlays: DWORD;   // maximum number of visible overlays
    dwCurrVisibleOverlays: DWORD;  // current number of visible overlays
    dwNumFourCCCodes: DWORD;       // number of four cc codes
    dwAlignBoundarySrc: DWORD;     // source rectangle alignment
    dwAlignSizeSrc: DWORD;         // source rectangle byte size
    dwAlignBoundaryDest: DWORD;    // dest rectangle alignment
    dwAlignSizeDest: DWORD;        // dest rectangle byte size
    dwAlignStrideAlign: DWORD;     // stride alignment
    dwRops: array[0..DD_ROP_SPACE-1] of DWORD;   // ROPS supported
    ddsOldCaps: TDDSCaps;          // Was TDDSCaps ddsCaps. ddsCaps is of type DDSCAPS2 for DX6
    dwMinOverlayStretch: DWORD;    // minimum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxOverlayStretch: DWORD;    // maximum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinLiveVideoStretch: DWORD;  // minimum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxLiveVideoStretch: DWORD;  // maximum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinHwCodecStretch: DWORD;    // minimum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxHwCodecStretch: DWORD;    // maximum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwReserved1: DWORD;            // reserved
    dwReserved2: DWORD;            // reserved
    dwReserved3: DWORD;            // reserved
    dwSVBCaps: DWORD;              // driver specific capabilities for System->Vmem blts
    dwSVBCKeyCaps: DWORD;          // driver color key capabilities for System->Vmem blts
    dwSVBFXCaps: DWORD;            // driver FX capabilities for System->Vmem blts
    dwSVBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->Vmem blts
    dwVSBCaps: DWORD;              // driver specific capabilities for Vmem->System blts
    dwVSBCKeyCaps: DWORD;          // driver color key capabilities for Vmem->System blts
    dwVSBFXCaps: DWORD;            // driver FX capabilities for Vmem->System blts
    dwVSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for Vmem->System blts
    dwSSBCaps: DWORD;              // driver specific capabilities for System->System blts
    dwSSBCKeyCaps: DWORD;          // driver color key capabilities for System->System blts
    dwSSBFXCaps: DWORD;            // driver FX capabilities for System->System blts
    dwSSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->System blts
    { Members added for DX5 }
    dwMaxVideoPorts: DWORD;        // maximum number of usable video ports
    dwCurrVideoPorts: DWORD;       // current number of video ports used
    dwSVBCaps2: DWORD;             // more driver specific capabilities for System->Vmem blts
    dwNLVBCaps: DWORD;             // driver specific capabilities for non-local->local vidmem blts
    dwNLVBCaps2: DWORD;            // more driver specific capabilities non-local->local vidmem blts
    dwNLVBCKeyCaps: DWORD;         // driver color key capabilities for non-local->local vidmem blts
    dwNLVBFXCaps: DWORD;           // driver FX capabilities for non-local->local blts
    dwNLVBRops: array[0..DD_ROP_SPACE-1] of DWORD; // ROPS supported for non-local->local blts
    { Members added for DX6 }
    ddsCaps: TDDSCaps2;            // Surface Caps
  end;

  PDDCaps_DX7 = ^TDDCaps_DX7;
  TDDCaps_DX7 = record
    dwSize: DWORD;                 // size of the DDDRIVERCAPS structure
    dwCaps: DWORD;                 // driver specific capabilities
    dwCaps2: DWORD;                // more driver specific capabilites
    dwCKeyCaps: DWORD;             // color key capabilities of the surface
    dwFXCaps: DWORD;               // driver specific stretching and effects capabilites
    dwFXAlphaCaps: DWORD;          // alpha driver specific capabilities
    dwPalCaps: DWORD;              // palette capabilities
    dwSVCaps: DWORD;               // stereo vision capabilities
    dwAlphaBltConstBitDepths: DWORD;       // DDBD_2,4,8
    dwAlphaBltPixelBitDepths: DWORD;       // DDBD_1,2,4,8
    dwAlphaBltSurfaceBitDepths: DWORD;     // DDBD_1,2,4,8
    dwAlphaOverlayConstBitDepths: DWORD;   // DDBD_2,4,8
    dwAlphaOverlayPixelBitDepths: DWORD;   // DDBD_1,2,4,8
    dwAlphaOverlaySurfaceBitDepths: DWORD; // DDBD_1,2,4,8
    dwZBufferBitDepths: DWORD;             // DDBD_8,16,24,32
    dwVidMemTotal: DWORD;          // total amount of video memory
    dwVidMemFree: DWORD;           // amount of free video memory
    dwMaxVisibleOverlays: DWORD;   // maximum number of visible overlays
    dwCurrVisibleOverlays: DWORD;  // current number of visible overlays
    dwNumFourCCCodes: DWORD;       // number of four cc codes
    dwAlignBoundarySrc: DWORD;     // source rectangle alignment
    dwAlignSizeSrc: DWORD;         // source rectangle byte size
    dwAlignBoundaryDest: DWORD;    // dest rectangle alignment
    dwAlignSizeDest: DWORD;        // dest rectangle byte size
    dwAlignStrideAlign: DWORD;     // stride alignment
    dwRops: array[0..DD_ROP_SPACE-1] of DWORD;   // ROPS supported
    ddsOldCaps: TDDSCaps;          // Was TDDSCaps ddsCaps. ddsCaps is of type DDSCAPS2 for DX6
    dwMinOverlayStretch: DWORD;    // minimum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxOverlayStretch: DWORD;    // maximum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinLiveVideoStretch: DWORD;  // minimum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxLiveVideoStretch: DWORD;  // maximum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMinHwCodecStretch: DWORD;    // minimum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwMaxHwCodecStretch: DWORD;    // maximum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
    dwReserved1: DWORD;            // reserved
    dwReserved2: DWORD;            // reserved
    dwReserved3: DWORD;            // reserved
    dwSVBCaps: DWORD;              // driver specific capabilities for System->Vmem blts
    dwSVBCKeyCaps: DWORD;          // driver color key capabilities for System->Vmem blts
    dwSVBFXCaps: DWORD;            // driver FX capabilities for System->Vmem blts
    dwSVBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->Vmem blts
    dwVSBCaps: DWORD;              // driver specific capabilities for Vmem->System blts
    dwVSBCKeyCaps: DWORD;          // driver color key capabilities for Vmem->System blts
    dwVSBFXCaps: DWORD;            // driver FX capabilities for Vmem->System blts
    dwVSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for Vmem->System blts
    dwSSBCaps: DWORD;              // driver specific capabilities for System->System blts
    dwSSBCKeyCaps: DWORD;          // driver color key capabilities for System->System blts
    dwSSBFXCaps: DWORD;            // driver FX capabilities for System->System blts
    dwSSBRops: array[0..DD_ROP_SPACE-1] of DWORD;// ROPS supported for System->System blts
    { Members added for DX5 }
    dwMaxVideoPorts: DWORD;        // maximum number of usable video ports
    dwCurrVideoPorts: DWORD;       // current number of video ports used
    dwSVBCaps2: DWORD;             // more driver specific capabilities for System->Vmem blts
    dwNLVBCaps: DWORD;             // driver specific capabilities for non-local->local vidmem blts
    dwNLVBCaps2: DWORD;            // more driver specific capabilities non-local->local vidmem blts
    dwNLVBCKeyCaps: DWORD;         // driver color key capabilities for non-local->local vidmem blts
    dwNLVBFXCaps: DWORD;           // driver FX capabilities for non-local->local blts
    dwNLVBRops: array[0..DD_ROP_SPACE-1] of DWORD; // ROPS supported for non-local->local blts
    { Members added for DX6 }
    ddsCaps: TDDSCaps2;            // Surface Caps
  end;
  TDDCaps = TDDCaps_DX7;
  PDDCaps = PDDCaps_DX7;

  DDCAPS = TDDCaps;
  LPDDCAPS = PDDCaps;

{ TDDPixelFormat structure }

  PDDPixelFormat = ^TDDPixelFormat;
  TDDPixelFormat = record
    dwSize: DWORD;                // size of structure
    dwFlags: DWORD;               // pixel format flags
    dwFourCC: DWORD;              // (FOURCC code)
    case Integer of
      0: (
        dwRGBBitCount: DWORD;          // how many bits per pixel
        dwRBitMask: DWORD;             // mask for red bit
        dwGBitMask: DWORD;             // mask for green bits
        dwBBitMask: DWORD;             // mask for blue bits
        dwRGBAlphaBitMask: DWORD;      // mask for alpha channel
        );
      1: (
        _union1a: DWORD;
        _union1b: DWORD;
        _union1c: DWORD;
        _union1d: DWORD;
        dwRGBZBitMask: DWORD;          // mask for Z channel
        );
      2: (
        dwYUVBitCount: DWORD;          // how many bits per pixel
        dwYBitMask: DWORD;             // mask for Y bits
        dwUBitMask: DWORD;             // mask for U bits
        dwVBitMask: DWORD;             // mask for V bits
        dwYUVAlphaBitMask: DWORD;      // mask for alpha channel
        );
      3: (
        _union3a: DWORD;
        _union3b: DWORD;
        _union3c: DWORD;
        _union3d: DWORD;
        dwYUVZBitMask: DWORD;          // mask for Z channel
        );
      4: (
        dwZBufferBitDepth: DWORD;      // how many bits for z buffers
        dwStencilBitDepth: DWORD;      // how many stencil bits (note: dwZBufferBitDepth-dwStencilBitDepth is total Z-only bits)
        dwZBitMask: DWORD;             // mask for Z bits
        dwStencilBitMask: DWORD;       // mask for stencil bits
        );
      5: (
        dwAlphaBitDepth: DWORD;        // how many bits for alpha channels
        );
      6: (
        dwLuminanceBitCount: DWORD;    // how many bits per pixel
        dwLuminanceBitMask: DWORD;     // mask for luminance bits
        _union6c: DWORD;
        _union6d: DWORD;
        dwLuminanceAlphaBitMask: DWORD;
       );
      7: (
        dwBumpBitCount: DWORD;         // how many bits per "buxel", total
        dwBumpDuBitMask: DWORD;        // mask for bump map U delta bits
        dwBumpDvBitMask: DWORD;        // mask for bump map V delta bits
        dwBumpLuminanceBitMask: DWORD; // mask for luminance in bump map
       );
  end;

  DDPIXELFORMAT = TDDPixelFormat;
  LPDDPIXELFORMAT = PDDPixelFormat;

{ DDOVERLAYFX structure }

  PDDOverlayFx = ^TDDOverlayFx;
  TDDOverlayFx = record
    dwSize: DWORD;                         // size of structure
    dwAlphaEdgeBlendBitDepth: DWORD;       // Bit depth used to specify constant for alpha edge blend
    dwAlphaEdgeBlend: DWORD;               // Constant to use as alpha for edge blend
    dwReserved: DWORD;
    dwAlphaDestConstBitDepth: DWORD;       // Bit depth used to specify alpha constant for destination
    case Integer of
    0: (
      dwAlphaDestConst: DWORD;             // Constant to use as alpha channel for dest
      dwAlphaSrcConstBitDepth: DWORD;      // Bit depth used to specify alpha constant for source
      dwAlphaSrcConst: DWORD;              // Constant to use as alpha channel for src
      dckDestColorkey: TDDColorKey;        // DestColorkey override
      dckSrcColorkey: TDDColorKey;         // DestColorkey override
      dwDDFX: DWORD;                       // Overlay FX
      dwFlags: DWORD;                      // flags
      );
    1: (
      lpDDSAlphaDest: Pointer{IDirectDrawSurface};  // Surface to use as alpha channel for dest
      _union1b: DWORD;
      lpDDSAlphaSrc: Pointer{IDirectDrawSurface};   // Surface to use as alpha channel for src
      );
  end;

  DDOVERLAYFX = TDDOverlayFx;
  LPDDOVERLAYFX = PDDOverlayFx;

{ TDDBltBatch structure }

  PDDBltBatch = ^TDDBltBatch;
  TDDBltBatch = record
    lprDest: PRect;
    lpDDSSrc: IDirectDrawSurface;
    lprSrc: PRect;
    dwFlags: DWORD;
    lpDDBltFx: PDDBltFX;
  end;

  DDBLTBATCH = TDDBltBatch;
  LPDDBLTBATCH = PDDBltBatch;

{ TDDSurfaceDesc structure }

  PDDSurfaceDesc = ^TDDSurfaceDesc;
  TDDSurfaceDesc = record
    dwSize: DWORD;                   // size of the TDDSurfaceDesc structure
    dwFlags: DWORD;                  // determines what fields are valid
    dwHeight: DWORD;                 // height of surface to be created
    dwWidth: DWORD;                  // width of input surface
    case Integer of
      0: (
        lPitch: Longint;
        dwBackBufferCount: DWORD;        // number of back buffers requested
        case Integer of
        0: (
          dwMipMapCount: DWORD;          // number of mip-map levels requested
          dwAlphaBitDepth: DWORD;        // depth of alpha buffer requested
          dwReserved: DWORD;             // reserved
          lpSurface: Pointer;            // pointer to the associated surface memory
          ddckCKDestOverlay: TDDColorKey;// color key for destination overlay use
          ddckCKDestBlt: TDDColorKey;    // color key for destination blt use
          ddckCKSrcOverlay: TDDColorKey; // color key for source overlay use
          ddckCKSrcBlt: TDDColorKey;     // color key for source blt use
          ddpfPixelFormat: TDDPixelFormat;// pixel format description of the surface
          ddsCaps: TDDSCaps;             // direct draw surface capabilities
          );
        1: (
          dwZBufferBitDepth: DWORD;      // depth of Z buffer requested
          );
        2: (
          dwRefreshRate: DWORD;          // refresh rate (used when display mode is described)
          );
      );
      1: (
        dwLinearSize: DWORD
      );
  end;

  DDSURFACEDESC = TDDSurfaceDesc;
  LPDDSURFACEDESC = PDDSurfaceDesc;

{ TDDSurfaceDesc2 structure }

  PDDSurfaceDesc2 = ^TDDSurfaceDesc2;
  TDDSurfaceDesc2 = record
    dwSize: DWORD;                   // size of the TDDSurfaceDesc2 structure
    dwFlags: DWORD;                  // determines what fields are valid
    dwHeight: DWORD;                 // height of surface to be created
    dwWidth: DWORD;                  // width of input surface
    case Integer of
      0: (
        lPitch: Longint;
        dwBackBufferCount: DWORD;        // number of back buffers requested
        case Integer of
        0: (
          dwMipMapCount: DWORD;          // number of mip-map levels requested
          dwAlphaBitDepth: DWORD;        // depth of alpha buffer requested
          dwReserved: DWORD;             // reserved
          lpSurface: Pointer;            // pointer to the associated surface memory
          ddckCKDestOverlay: TDDColorKey;// color key for destination overlay use
          ddckCKDestBlt: TDDColorKey;    // color key for destination blt use
          ddckCKSrcOverlay: TDDColorKey; // color key for source overlay use
          ddckCKSrcBlt: TDDColorKey;     // color key for source blt use
          ddpfPixelFormat: TDDPixelFormat;// pixel format description of the surface
          ddsCaps: TDDSCaps2;            // direct draw surface capabilities
          dwTextureStage: DWORD;         // stage in multitexture cascade
          );
        1: (
          dwRefreshRate: DWORD;          // refresh rate (used when display mode is described)
          );
      );
      1: (
        dwLinearSize: DWORD
      );
  end;

  DDSURFACEDESC2 = TDDSurfaceDesc2;
  LPDDSURFACEDESC2 = PDDSurfaceDesc2;

{ TDDOptSurfaceDesc structure }

  PDDOptSurfaceDesc = ^TDDOptSurfaceDesc;
  TDDOptSurfaceDesc = record
    dwSize: DWORD;             // size of the DDOPTSURFACEDESC structure
    dwFlags: DWORD;            // determines what fields are valid
    ddSCaps: TDDSCaps2;        // Common caps like: Memory type
    ddOSCaps: TDDOSCaps;       // Common caps like: Memory type
    guid: TGUID;               // Compression technique GUID
    dwCompressionRatio: DWORD; // Compression ratio
  end;

  DDOPTSURFACEDESC = TDDOptSurfaceDesc;
  LPDDOPTSURFACEDESC = PDDOptSurfaceDesc;

{ TDDColorControl structure }

  PDDColorControl = ^TDDColorControl;
  TDDColorControl = record
    dwSize: DWORD;
    dwFlags: DWORD;
    lBrightness: Longint;
    lContrast: Longint;
    lHue: Longint;
    lSaturation: Longint;
    lSharpness: Longint;
    lGamma: Longint;
    lColorEnable: Longint;
    dwReserved1: DWORD;
  end;

  DDCOLORCONTROL = TDDColorControl;
  LPDDCOLORCONTROL = PDDCOLORCONTROL;

{ TDDGammaRamp structure }

  PDDGammaRamp = ^TDDGammaRamp;
  TDDGammaRamp = record
    Red: array[0..255] of Word;
    Green: array[0..255] of Word;
    Blue: array[0..255] of Word;
  end;

  DDGAMMARAMP = TDDGammaRamp;
  LPDDGAMMARAMP = PDDGammaRamp;

{ TDDDeviceIdentifier structure }

  PDDDeviceIdentifier = ^TDDDeviceIdentifier;
  TDDDeviceIdentifier = record
    //
    // These elements are for presentation to the user only. They should not be used to identify particular
    // drivers, since this is unreliable and many different strings may be associated with the same
    // device, and the same driver from different vendors.
    //
    szDriver: array[0..MAX_DDDEVICEID_STRING-1] of Char;
    szDescription: array[0..MAX_DDDEVICEID_STRING-1] of Char;

    //
    // This element is the version of the DirectDraw/3D driver. It is legal to do <, > comparisons
    // on the whole 64 bits. Caution should be exercised if you use this element to identify problematic
    // drivers. It is recommended that guidDeviceIdentifier is used for this purpose.
    //
    // This version has the form:
    //  wProduct = HIWORD(liDriverVersion.HighPart)
    //  wVersion = LOWORD(liDriverVersion.HighPart)
    //  wSubVersion = HIWORD(liDriverVersion.LowPart)
    //  wBuild = LOWORD(liDriverVersion.LowPart)
    //
    liDriverVersion: TLargeInteger;     // Defined for applications and other 32 bit components

    //
    // These elements can be used to identify particular chipsets. Use with extreme caution.
    //   dwVendorId     Identifies the manufacturer. May be zero if unknown.
    //   dwDeviceId     Identifies the type of chipset. May be zero if unknown.
    //   dwSubSysId     Identifies the subsystem, typically this means the particular board. May be zero if unknown.
    //   dwRevision     Identifies the revision level of the chipset. May be zero if unknown.
    //
    dwVendorId: DWORD;
    dwDeviceId: DWORD;
    dwSubSysId: DWORD;
    dwRevision: DWORD;

    //
    // This element can be used to check changes in driver/chipset. This GUID is a unique identifier for the
    // driver/chipset pair. Use this element if you wish to track changes to the driver/chipset in order to
    // reprofile the graphics subsystem.
    // This element can also be used to identify particular problematic drivers.
    //
    guidDeviceIdentifier: TGUID;
  end;

  DDDEVICEIDENTIFIER = TDDDeviceIdentifier;
  LPDDDEVICEIDENTIFIER = PDDDeviceIdentifier;

{ TDDDeviceIdentifier2 structure }

  PDDDeviceIdentifier2 = ^TDDDeviceIdentifier2;
  TDDDeviceIdentifier2 = record
    //
    // These elements are for presentation to the user only. They should not be used to identify particular
    // drivers, since this is unreliable and many different strings may be associated with the same
    // device, and the same driver from different vendors.
    //
    szDriver: array[0..MAX_DDDEVICEID_STRING-1] of Char;
    szDescription: array[0..MAX_DDDEVICEID_STRING-1] of Char;

    //
    // This element is the version of the DirectDraw/3D driver. It is legal to do <, > comparisons
    // on the whole 64 bits. Caution should be exercised if you use this element to identify problematic
    // drivers. It is recommended that guidDeviceIdentifier is used for this purpose.
    //
    // This version has the form:
    //  wProduct = HIWORD(liDriverVersion.HighPart)
    //  wVersion = LOWORD(liDriverVersion.HighPart)
    //  wSubVersion = HIWORD(liDriverVersion.LowPart)
    //  wBuild = LOWORD(liDriverVersion.LowPart)
    //
    liDriverVersion: TLargeInteger;     // Defined for applications and other 32 bit components

    //
    // These elements can be used to identify particular chipsets. Use with extreme caution.
    //   dwVendorId     Identifies the manufacturer. May be zero if unknown.
    //   dwDeviceId     Identifies the type of chipset. May be zero if unknown.
    //   dwSubSysId     Identifies the subsystem, typically this means the particular board. May be zero if unknown.
    //   dwRevision     Identifies the revision level of the chipset. May be zero if unknown.
    //
    dwVendorId: DWORD;
    dwDeviceId: DWORD;
    dwSubSysId: DWORD;
    dwRevision: DWORD;

    //
    // This element can be used to check changes in driver/chipset. This GUID is a unique identifier for the
    // driver/chipset pair. Use this element if you wish to track changes to the driver/chipset in order to
    // reprofile the graphics subsystem.
    // This element can also be used to identify particular problematic drivers.
    //
    guidDeviceIdentifier: TGUID;

    //
    // This element is used to determine the Windows Hardware Quality Lab (WHQL)
    // certification level for this driver/device pair.
    //
    dwWHQLLevel: DWORD;
  end;

  DDDEVICEIDENTIFIER2 = TDDDeviceIdentifier2;
  LPDDDEVICEIDENTIFIER2 = PDDDeviceIdentifier2;

{ Callbacks }

  TClipperCallback = function(lpDDClipper: IDirectDrawClipper; hWnd: HWND;
      Code: DWORD; lpContext: Pointer): HResult; stdcall;
  LPCLIPPERCALLBACK = TClipperCallback;

  TSurfacesStreamingCallback = function(Arg: DWORD): HResult; stdcall;
  LPSURFACESTREAMINGCALLBACK =TSurfacesStreamingCallback;

  TDDEnumModesCallback = function(const lpDDSurfaceDesc: TDDSurfaceDesc;
      lpContext: Pointer): HResult; stdcall;
  LPDDENUMMODESCALLBACK = TDDEnumModesCallback;

  TDDEnumModesCallback2 = function(const lpDDSurfaceDesc: TDDSurfaceDesc2;
      lpContext: Pointer): HResult; stdcall;
  LPDDENUMMODESCALLBACK2 = TDDEnumModesCallback2;

  TDDEnumSurfacesCallback = function(lpDDSurface: IDirectDrawSurface;
      const lpDDSurfaceDesc: TDDSurfaceDesc; lpContext: Pointer): HResult; stdcall;
  LPDDENUMSURFACESCALLBACK = TDDEnumSurfacesCallback;



{ IDirectDraw Interface }

  IDirectDraw = interface(IUnknown)
    ['{6C14DB80-A733-11CE-A521-0020AF0BE560}']
    // IDirectDraw methods
    function Compact: HResult; stdcall;
    function CreateClipper(dwFlags: DWORD; out lplpDDClipper: IDirectDrawClipper;
        pUnkOuter: IUnknown): HResult; stdcall;
    function CreatePalette(dwFlags: DWORD; lpColorTable: PPaletteEntry;
        out lplpDDPalette: IDirectDrawPalette; pUnkOuter: IUnknown): HResult; stdcall;
    function CreateSurface(const lpDDSurfaceDesc: TDDSurfaceDesc;
        out lplpDDSurface: IDirectDrawSurface; pUnkOuter: IUnknown): HResult; stdcall;
    function DuplicateSurface(lpDDSurface: IDirectDrawSurface;
        out lplpDupDDSurface: IDirectDrawSurface): HResult; stdcall;
    function EnumDisplayModes(dwFlags: DWORD;
        const lpDDSurfaceDesc: TDDSurfaceDesc; lpContext: Pointer;
        lpEnumModesCallback: TDDEnumModesCallback): HResult; stdcall;
    function EnumSurfaces(dwFlags: DWORD; const lpDDSD: TDDSurfaceDesc;
        lpContext: Pointer; lpEnumCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function FlipToGDISurface: HResult; stdcall;
    function GetCaps(var lpDDDriverCaps: TDDCaps; var lpDDHELCaps: TDDCaps): HResult; stdcall;
    function GetDisplayMode(var lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function GetFourCCCodes(var lpNumCodes, lpCodes: DWORD): HResult; stdcall;
    function GetGDISurface(out lplpGDIDDSSurface: IDirectDrawSurface): HResult; stdcall;
    function GetMonitorFrequency(var lpdwFrequency: DWORD): HResult; stdcall;
    function GetScanLine(var lpdwScanLine: DWORD): HResult; stdcall;
    function GetVerticalBlankStatus(var lpbIsInVB: BOOL): HResult; stdcall;
    function Initialize(lpGUID: PGUID): HResult; stdcall;
    function RestoreDisplayMode: HResult; stdcall;
    function SetCooperativeLevel(hWnd: HWND; dwFlags: DWORD): HResult; stdcall;
    function SetDisplayMode(dwWidth, dwHeight, dwBpp: DWORD): HResult; stdcall;
    function WaitForVerticalBlank(dwFlags: DWORD; hEvent: THandle): HResult; stdcall;
  end;

{ IDirectDraw2 Interface }

  IDirectDraw2 = interface(IUnknown)
    ['{B3A6F3E0-2B43-11CF-A2DE-00AA00B93356}']
    // IDirectDraw methods
    function Compact: HResult; stdcall;
    function CreateClipper(dwFlags: DWORD; out lplpDDClipper: IDirectDrawClipper;
        pUnkOuter: IUnknown): HResult; stdcall;
    function CreatePalette(dwFlags: DWORD; lpColorTable: PPaletteEntry;
        out lplpDDPalette: IDirectDrawPalette; pUnkOuter: IUnknown): HResult; stdcall;
    function CreateSurface(const lpDDSurfaceDesc: TDDSurfaceDesc;
        out lplpDDSurface: IDirectDrawSurface; pUnkOuter: IUnknown): HResult; stdcall;
    function DuplicateSurface(lpDDSurface: IDirectDrawSurface;
        out lplpDupDDSurface: IDirectDrawSurface): HResult; stdcall;
    function EnumDisplayModes(dwFlags: DWORD;
        const lpDDSurfaceDesc: TDDSurfaceDesc; lpContext: Pointer;
        lpEnumModesCallback: TDDEnumModesCallback): HResult; stdcall;
    function EnumSurfaces(dwFlags: DWORD; const lpDDSD: TDDSurfaceDesc;
        lpContext: Pointer; lpEnumCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function FlipToGDISurface: HResult; stdcall;
    function GetCaps(var lpDDDriverCaps: TDDCaps; var lpDDHELCaps: TDDCaps): HResult; stdcall;
    function GetDisplayMode(var lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function GetFourCCCodes(var lpNumCodes, lpCodes: DWORD): HResult; stdcall;
    function GetGDISurface(out lplpGDIDDSSurface: IDirectDrawSurface): HResult; stdcall;
    function GetMonitorFrequency(var lpdwFrequency: DWORD): HResult; stdcall;
    function GetScanLine(var lpdwScanLine: DWORD): HResult; stdcall;
    function GetVerticalBlankStatus(var lpbIsInVB: BOOL): HResult; stdcall;
    function Initialize(lpGUID: PGUID): HResult; stdcall;
    function RestoreDisplayMode: HResult; stdcall;
    function SetCooperativeLevel(hWnd: HWND; dwFlags: DWORD): HResult; stdcall;
    function SetDisplayMode(dwWidth, dwHeight, dwBPP, dwRefreshRate: DWORD;
        dwFlags: DWORD): HResult; stdcall;
    function WaitForVerticalBlank(dwFlags: DWORD; hEvent: THandle): HResult; stdcall;
    // IDirectDraw2 methods
    function GetAvailableVidMem(var lpDDSCaps: TDDSCaps;
        var lpdwTotal, lpdwFree: DWORD): HResult; stdcall;
  end;



{ IDirectDrawPalette Interface }

  IDirectDrawPalette = interface(IUnknown)
    ['{6C14DB84-A733-11CE-A521-0020AF0BE560}']
    // IDirectDrawPalette methods
    function GetCaps(varlpdwCaps: DWORD): HResult; stdcall;
    function GetEntries(dwFlags: DWORD; dwBase: DWORD; dwNumEntries: DWORD;
        lpEntries: PPaletteEntry): HResult; stdcall;
    function Initialize(lpDD: IDirectDraw; dwFlags: DWORD;
        lpDDColorTable: PPaletteEntry): HResult; stdcall;
    function SetEntries(dwFlags: DWORD; dwStartingEntry: DWORD;
        dwCount: DWORD; lpEntries: PPaletteEntry): HResult; stdcall;
  end;

{ IDirectDrawClipper Interface }

  IDirectDrawClipper = interface(IUnknown)
    ['{6C14DB85-A733-11CE-A521-0020AF0BE560}']
    // IDirectDrawClipper methods
    function GetClipList(const lpRect: TRect; lpClipList: PRgnData;
        var lpdwSize: DWORD): HResult; stdcall;
    function GetHWnd(var lphWnd: HWND): HResult; stdcall;
    function Initialize(lpDD: IDirectDraw; dwFlags: DWORD): HResult; stdcall;
    function IsClipListChanged(var lpbChanged: BOOL): HResult; stdcall;
    function SetClipList(lpClipList: PRgnData; dwFlags: DWORD): HResult; stdcall;
    function SetHWnd(dwFlags: DWORD; hWnd: HWND): HResult; stdcall;
  end;

{ IDirectDrawSurface Interface }

  IDirectDrawSurface = interface(IUnknown)
    ['{6C14DB81-A733-11CE-A521-0020AF0BE560}']
    // IDirectDrawSurface methods
    function AddAttachedSurface(lpDDSAttachedSurface: IDirectDrawSurface): HResult; stdcall;
    function AddOverlayDirtyRect(const lpRect: TRect): HResult; stdcall;
    function Blt(const lpDestRect: TRect; lpDDSrcSurface: IDirectDrawSurface;
        const lpSrcRect: TRect; dwFlags: DWORD; const lpDDBltFx: TDDBltFX): HResult; stdcall;
    function BltBatch(const lpDDBltBatch: TDDBltBatch; dwCount: DWORD;
        dwFlags: DWORD): HResult; stdcall;
    function BltFast(dwX, dwY: DWORD; lpDDSrcSurface: IDirectDrawSurface;
        const lpSrcRect: TRect; dwTrans: DWORD): HResult; stdcall;
    function DeleteAttachedSurface(dwFlags: DWORD;
        lpDDSAttachedSurface: IDirectDrawSurface): HResult; stdcall;
    function EnumAttachedSurfaces(lpContext: Pointer;
        lpEnumSurfacesCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function EnumOverlayZOrders(dwFlags: DWORD; lpContext: Pointer;
        lpfnCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function Flip(lpDDSurfaceTargetOverride: IDirectDrawSurface;
        dwFlags: DWORD): HResult; stdcall;
    function GetAttachedSurface(var lpDDSCaps: TDDSCaps;
        out lplpDDAttachedSurface: IDirectDrawSurface): HResult; stdcall;
    function GetBltStatus(dwFlags: DWORD): HResult; stdcall;
    function GetCaps(var lpDDSCaps: TDDSCaps): HResult; stdcall;
    function GetClipper(out lplpDDClipper: IDirectDrawClipper): HResult; stdcall;
    function GetColorKey(dwFlags: DWORD; var lpDDColorKey: TDDColorKey): HResult; stdcall;
    function GetDC(var lphDC: LongWord): HResult; stdcall;
    function GetFlipStatus(dwFlags: DWORD): HResult; stdcall;
    function GetOverlayPosition(var lplX, lplY: Longint): HResult; stdcall;
    function GetPalette(out lplpDDPalette: IDirectDrawPalette): HResult; stdcall;
    function GetPixelFormat(var lpDDPixelFormat: TDDPixelFormat): HResult; stdcall;
    function GetSurfaceDesc(var lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function Initialize(lpDD: IDirectDraw;
        const lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function IsLost: HResult; stdcall;
    function Lock(lpDestRect: PRect; var lpDDSurfaceDesc: TDDSurfaceDesc;
        dwFlags: DWORD; hEvent: THandle): HResult; stdcall;
    function ReleaseDC(hDC: LongWord): HResult; stdcall;
    function Restore: HResult; stdcall;
    function SetClipper(lpDDClipper: IDirectDrawClipper): HResult; stdcall;
    function SetColorKey(dwFlags: DWORD; const lpDDColorKey: TDDColorKey): HResult; stdcall;
    function SetOverlayPosition(lX, lY: Longint): HResult; stdcall;
    function SetPalette(lpDDPalette: IDirectDrawPalette): HResult; stdcall;
    function Unlock(lpSurfaceData: Pointer): HResult; stdcall;
    function UpdateOverlay(const lpSrcRect: TRect;
        lpDDDestSurface: IDirectDrawSurface; const lpDestRect: TRect;
        dwFlags: DWORD; const lpDDOverlayFx: TDDOverlayFX): HResult; stdcall;
    function UpdateOverlayDisplay(dwFlags: DWORD): HResult; stdcall;
    function UpdateOverlayZOrder(dwFlags: DWORD;
        lpDDSReference: IDirectDrawSurface): HResult; stdcall;
  end;

{ IDirectDrawSurface2 Interface }

  IDirectDrawSurface2 = interface(IUnknown)
    ['{57805885-6EEC-11CF-9441-A82303C10E27}']
    // IDirectDrawSurface methods
    function AddAttachedSurface(lpDDSAttachedSurface: IDirectDrawSurface2): HResult; stdcall;
    function AddOverlayDirtyRect(const lpRect: TRect): HResult; stdcall;
    function Blt(const lpDestRect: TRect; lpDDSrcSurface: IDirectDrawSurface2;
        const lpSrcRect: TRect; dwFlags: DWORD; const lpDDBltFx: TDDBltFX): HResult; stdcall;
    function BltBatch(const lpDDBltBatch: TDDBltBatch; dwCount: DWORD;
        dwFlags: DWORD): HResult; stdcall;
    function BltFast(dwX, dwY: DWORD; lpDDSrcSurface: IDirectDrawSurface2;
        const lpSrcRect: TRect; dwTrans: DWORD): HResult; stdcall;
    function DeleteAttachedSurface(dwFlags: DWORD;
        lpDDSAttachedSurface: IDirectDrawSurface2): HResult; stdcall;
    function EnumAttachedSurfaces(lpContext: Pointer;
        lpEnumSurfacesCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function EnumOverlayZOrders(dwFlags: DWORD; lpContext: Pointer;
        lpfnCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function Flip(lpDDSurfaceTargetOverride: IDirectDrawSurface2;
        dwFlags: DWORD): HResult; stdcall;
    function GetAttachedSurface(var lpDDSCaps: TDDSCaps;
        out lplpDDAttachedSurface: IDirectDrawSurface2): HResult; stdcall;
    function GetBltStatus(dwFlags: DWORD): HResult; stdcall;
    function GetCaps(var lpDDSCaps: TDDSCaps): HResult; stdcall;
    function GetClipper(out lplpDDClipper: IDirectDrawClipper): HResult; stdcall;
    function GetColorKey(dwFlags: DWORD; var lpDDColorKey: TDDColorKey): HResult; stdcall;
    function GetDC(var lphDC: HDC): HResult; stdcall;
    function GetFlipStatus(dwFlags: DWORD): HResult; stdcall;
    function GetOverlayPosition(var lplX, lplY: Longint): HResult; stdcall;
    function GetPalette(out lplpDDPalette: IDirectDrawPalette): HResult; stdcall;
    function GetPixelFormat(var lpDDPixelFormat: TDDPixelFormat): HResult; stdcall;
    function GetSurfaceDesc(var lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function Initialize(lpDD: IDirectDraw; const lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function IsLost: HResult; stdcall;
    function Lock(lpDestRect: PRect; const lpDDSurfaceDesc: TDDSurfaceDesc;
        dwFlags: DWORD; hEvent: THandle): HResult; stdcall;
    function ReleaseDC(hDC: HDC): HResult; stdcall;
    function Restore: HResult; stdcall;
    function SetClipper(lpDDClipper: IDirectDrawClipper): HResult; stdcall;
    function SetColorKey(dwFlags: DWORD; const lpDDColorKey: TDDColorKey): HResult; stdcall;
    function SetOverlayPosition(lX, lY: Longint): HResult; stdcall;
    function SetPalette(lpDDPalette: IDirectDrawPalette): HResult; stdcall;
    function Unlock(lpSurfaceData: Pointer): HResult; stdcall;
    function UpdateOverlay(const lpSrcRect: TRect;
        lpDDDestSurface: IDirectDrawSurface2; const lpDestRect: TRect;
        dwFlags: DWORD; const lpDDOverlayFx: TDDOverlayFX): HResult; stdcall;
    function UpdateOverlayDisplay(dwFlags: DWORD): HResult; stdcall;
    function UpdateOverlayZOrder(dwFlags: DWORD;
        lpDDSReference: IDirectDrawSurface2): HResult; stdcall;
    // IDirectDrawSurface2 methods
    function GetDDInterface(out lplpDD: IUnknown): HResult; stdcall;
    function PageLock(dwFlags: DWORD): HResult; stdcall;
    function PageUnlock(dwFlags: DWORD): HResult; stdcall;
  end;

{ IDirectDrawSurface3 Interface }

  IDirectDrawSurface3 = interface(IUnknown)
    ['{DA044E00-69B2-11D0-A1D5-00AA00B8DFBB}']
    // IDirectDrawSurface methods
    function AddAttachedSurface(lpDDSAttachedSurface: IDirectDrawSurface3): HResult; stdcall;
    function AddOverlayDirtyRect(const lpRect: TRect): HResult; stdcall;
    function Blt(const lpDestRect: TRect; lpDDSrcSurface: IDirectDrawSurface3;
        const lpSrcRect: TRect; dwFlags: DWORD; const lpDDBltFx: TDDBltFX): HResult; stdcall;
    function BltBatch(const lpDDBltBatch: TDDBltBatch; dwCount: DWORD;
        dwFlags: DWORD): HResult; stdcall;
    function BltFast(dwX, dwY: DWORD; lpDDSrcSurface: IDirectDrawSurface3;
        const lpSrcRect: TRect; dwTrans: DWORD): HResult; stdcall;
    function DeleteAttachedSurface(dwFlags: DWORD;
        lpDDSAttachedSurface: IDirectDrawSurface3): HResult; stdcall;
    function EnumAttachedSurfaces(lpContext: Pointer;
        lpEnumSurfacesCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function EnumOverlayZOrders(dwFlags: DWORD; lpContext: Pointer;
        lpfnCallback: TDDEnumSurfacesCallback): HResult; stdcall;
    function Flip(lpDDSurfaceTargetOverride: IDirectDrawSurface3;
        dwFlags: DWORD): HResult; stdcall;
    function GetAttachedSurface(var lpDDSCaps: TDDSCaps;
        out lplpDDAttachedSurface: IDirectDrawSurface3): HResult; stdcall;
    function GetBltStatus(dwFlags: DWORD): HResult; stdcall;
    function GetCaps(var lpDDSCaps: TDDSCaps): HResult; stdcall;
    function GetClipper(out lplpDDClipper: IDirectDrawClipper): HResult; stdcall;
    function GetColorKey(dwFlags: DWORD; var lpDDColorKey: TDDColorKey): HResult; stdcall;
    function GetDC(var lphDC: HDC): HResult; stdcall;
    function GetFlipStatus(dwFlags: DWORD): HResult; stdcall;
    function GetOverlayPosition(var lplX, lplY: Longint): HResult; stdcall;
    function GetPalette(out lplpDDPalette: IDirectDrawPalette): HResult; stdcall;
    function GetPixelFormat(var lpDDPixelFormat: TDDPixelFormat): HResult; stdcall;
    function GetSurfaceDesc(var lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function Initialize(lpDD: IDirectDraw; const lpDDSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function IsLost: HResult; stdcall;
    function Lock(lpDestRect: PRect; const lpDDSurfaceDesc: TDDSurfaceDesc;
        dwFlags: DWORD; hEvent: THandle): HResult; stdcall;
    function ReleaseDC(hDC: HDC): HResult; stdcall;
    function Restore: HResult; stdcall;
    function SetClipper(lpDDClipper: IDirectDrawClipper): HResult; stdcall;
    function SetColorKey(dwFlags: DWORD; const lpDDColorKey: TDDColorKey): HResult; stdcall;
    function SetOverlayPosition(lX, lY: Longint): HResult; stdcall;
    function SetPalette(lpDDPalette: IDirectDrawPalette): HResult; stdcall;
    function Unlock(lpSurfaceData: Pointer): HResult; stdcall;
    function UpdateOverlay(const lpSrcRect: TRect;
        lpDDDestSurface: IDirectDrawSurface3; const lpDestRect: TRect;
        dwFlags: DWORD; const lpDDOverlayFx: TDDOverlayFX): HResult; stdcall;
    function UpdateOverlayDisplay(dwFlags: DWORD): HResult; stdcall;
    function UpdateOverlayZOrder(dwFlags: DWORD;
        lpDDSReference: IDirectDrawSurface3): HResult; stdcall;
    // IDirectDrawSurface2 methods
    function GetDDInterface(out lplpDD: IUnknown): HResult; stdcall;
    function PageLock(dwFlags: DWORD): HResult; stdcall;
    function PageUnlock(dwFlags: DWORD): HResult; stdcall;
    // IDirectDrawSurface3 methods
    function SetSurfaceDesc(const lpddsd: TDDSurfaceDesc; dwFlags: DWORD): HResult; stdcall;
  end;

{ IDirectDrawColorControl Interface }

  IDirectDrawColorControl = interface(IUnknown)
    ['{4B9F0EE0-0D7E-11D0-9B06-00A0C903A3B8}']
    // IDirectDrawColorControl methods
    function GetColorControls(var lpColorControl: TDDColorControl): HResult; stdcall;
    function SetColorControls(const lpColorControl: TDDColorControl): HResult; stdcall;
  end;

{ IDirectDrawGammaControl Interface }

  IDirectDrawGammaControl = interface(IUnknown)
    ['{69C11C3E-B46B-11D1-AD7A-00C04FC29B4E}']
    // IDirectDrawGammaControl methods
    function GetGammaRamp(dwFlags: DWORD; var lpRampData: TDDGammaRamp): HResult; stdcall;
    function SetGammaRamp(dwFlags: DWORD; const lpRampData: TDDGammaRamp): HResult; stdcall;
  end;

const
{ Flags for DirectDrawEnumerateEx }
  DDENUM_ATTACHEDSECONDARYDEVICES = $00000001;
  DDENUM_DETACHEDSECONDARYDEVICES = $00000002;
  DDENUM_NONDISPLAYDEVICES        = $00000004;

{ Flags for the IDirectDraw4.GetDeviceIdentifier method }
  DDGDI_GETHOSTIDENTIFIER = $00000001;

{ ddsCaps field is valid. }
  DDSD_CAPS               = $00000001;     // default
  DDSD_HEIGHT             = $00000002;
  DDSD_WIDTH              = $00000004;
  DDSD_PITCH              = $00000008;
  DDSD_BACKBUFFERCOUNT    = $00000020;
  DDSD_ZBUFFERBITDEPTH    = $00000040;
  DDSD_ALPHABITDEPTH      = $00000080;
  DDSD_LPSURFACE          = $00000800;
  DDSD_PIXELFORMAT        = $00001000;
  DDSD_CKDESTOVERLAY      = $00002000;
  DDSD_CKDESTBLT          = $00004000;
  DDSD_CKSRCOVERLAY       = $00008000;
  DDSD_CKSRCBLT           = $00010000;
  DDSD_MIPMAPCOUNT        = $00020000;
  DDSD_REFRESHRATE        = $00040000;
  DDSD_LINEARSIZE         = $00080000;
  DDSD_TEXTURESTAGE       = $00100000;
  DDSD_FVF                = $00200000;
  DDSD_SRCVBHANDLE        = $00400000;
  DDSD_ALL                = $007ff9ee;

{ DirectDraw Driver Capability Flags }

  DDCAPS_3D                   = $00000001;
  DDCAPS_ALIGNBOUNDARYDEST    = $00000002;
  DDCAPS_ALIGNSIZEDEST        = $00000004;
  DDCAPS_ALIGNBOUNDARYSRC     = $00000008;
  DDCAPS_ALIGNSIZESRC         = $00000010;
  DDCAPS_ALIGNSTRIDE          = $00000020;
  DDCAPS_BLT                  = $00000040;
  DDCAPS_BLTQUEUE             = $00000080;
  DDCAPS_BLTFOURCC            = $00000100;
  DDCAPS_BLTSTRETCH           = $00000200;
  DDCAPS_GDI                  = $00000400;
  DDCAPS_OVERLAY              = $00000800;
  DDCAPS_OVERLAYCANTCLIP      = $00001000;
  DDCAPS_OVERLAYFOURCC        = $00002000;
  DDCAPS_OVERLAYSTRETCH       = $00004000;
  DDCAPS_PALETTE              = $00008000;
  DDCAPS_PALETTEVSYNC         = $00010000;
  DDCAPS_READSCANLINE         = $00020000;
  DDCAPS_STEREOVIEW           = $00040000;
  DDCAPS_VBI                  = $00080000;
  DDCAPS_ZBLTS                = $00100000;
  DDCAPS_ZOVERLAYS            = $00200000;
  DDCAPS_COLORKEY             = $00400000;
  DDCAPS_ALPHA                = $00800000;
  DDCAPS_COLORKEYHWASSIST     = $01000000;
  DDCAPS_NOHARDWARE           = $02000000;
  DDCAPS_BLTCOLORFILL         = $04000000;
  DDCAPS_BANKSWITCHED         = $08000000;
  DDCAPS_BLTDEPTHFILL         = $10000000;
  DDCAPS_CANCLIP              = $20000000;
  DDCAPS_CANCLIPSTRETCHED     = $40000000;
  DDCAPS_CANBLTSYSMEM         = $80000000;

{ More DirectDraw Driver Capability Flags (dwCaps2) }

  DDCAPS2_CERTIFIED            = $00000001;
  DDCAPS2_NO2DDURING3DSCENE    = $00000002;
  DDCAPS2_VIDEOPORT            = $00000004;
  DDCAPS2_AUTOFLIPOVERLAY      = $00000008;
  DDCAPS2_CANBOBINTERLEAVED    = $00000010;
  DDCAPS2_CANBOBNONINTERLEAVED = $00000020;
  DDCAPS2_COLORCONTROLOVERLAY  = $00000040;
  DDCAPS2_COLORCONTROLPRIMARY  = $00000080;
  DDCAPS2_CANDROPZ16BIT        = $00000100;
  DDCAPS2_NONLOCALVIDMEM       = $00000200;
  DDCAPS2_NONLOCALVIDMEMCAPS   = $00000400;
  DDCAPS2_NOPAGELOCKREQUIRED   = $00000800;
  DDCAPS2_WIDESURFACES         = $00001000;
  DDCAPS2_CANFLIPODDEVEN       = $00002000;
  DDCAPS2_CANBOBHARDWARE       = $00004000;
  DDCAPS2_COPYFOURCC           = $00008000;
  DDCAPS2_PRIMARYGAMMA         = $00020000;
  DDCAPS2_CANRENDERWINDOWED    = $00080000;
  DDCAPS2_CANCALIBRATEGAMMA    = $00100000;
  DDCAPS2_FLIPINTERVAL         = $00200000;
  DDCAPS2_FLIPNOVSYNC          = $00400000;
  DDCAPS2_CANMANAGETEXTURE     = $00800000;
  DDCAPS2_TEXMANINNONLOCALVIDMEM = $01000000;
  DDCAPS2_STEREO                 = $02000000;
  DDCAPS2_SYSTONONLOCAL_AS_SYSTOLOCAL = $04000000;

{ DirectDrawSurface Capability Flags }

  DDSCAPS_RESERVED1           = $00000001; { DDSCAPS_3D }
  DDSCAPS_ALPHA               = $00000002;
  DDSCAPS_BACKBUFFER          = $00000004;
  DDSCAPS_COMPLEX             = $00000008;
  DDSCAPS_FLIP                = $00000010;
  DDSCAPS_FRONTBUFFER         = $00000020;
  DDSCAPS_OFFSCREENPLAIN      = $00000040;
  DDSCAPS_OVERLAY             = $00000080;
  DDSCAPS_PALETTE             = $00000100;
  DDSCAPS_PRIMARYSURFACE      = $00000200;
  DDSCAPS_RESERVED3           = $00000400; { DDSCAPS_PRIMARYSURFACELEFT }
  DDSCAPS_SYSTEMMEMORY        = $00000800;
  DDSCAPS_TEXTURE             = $00001000;
  DDSCAPS_3DDEVICE            = $00002000;
  DDSCAPS_VIDEOMEMORY         = $00004000;
  DDSCAPS_VISIBLE             = $00008000;
  DDSCAPS_WRITEONLY           = $00010000;
  DDSCAPS_ZBUFFER             = $00020000;
  DDSCAPS_OWNDC               = $00040000;
  DDSCAPS_LIVEVIDEO           = $00080000;
  DDSCAPS_HWCODEC             = $00100000;
  DDSCAPS_MODEX               = $00200000;
  DDSCAPS_MIPMAP              = $00400000;
  DDSCAPS_RESERVED2           = $00800000;
  DDSCAPS_ALLOCONLOAD         = $04000000;
  DDSCAPS_VIDEOPORT           = $08000000;
  DDSCAPS_LOCALVIDMEM         = $10000000;
  DDSCAPS_NONLOCALVIDMEM      = $20000000;
  DDSCAPS_STANDARDVGAMODE     = $40000000;
  DDSCAPS_OPTIMIZED           = $80000000;

{ DirectDrawSurface Capability Flags 2 }

  DDSCAPS2_HARDWAREDEINTERLACE = $00000002;
  DDSCAPS2_HINTDYNAMIC         = $00000004;
  DDSCAPS2_HINTSTATIC          = $00000008;
  DDSCAPS2_TEXTUREMANAGE       = $00000010;
  DDSCAPS2_RESERVED1           = $00000020;
  DDSCAPS2_RESERVED2           = $00000040;
  DDSCAPS2_OPAQUE              = $00000080;
  DDSCAPS2_HINTANTIALIASING    = $00000100;
  DDSCAPS2_CUBEMAP             = $00000200;
  DDSCAPS2_CUBEMAP_POSITIVEX   = $00000400;
  DDSCAPS2_CUBEMAP_NEGATIVEX   = $00000800;
  DDSCAPS2_CUBEMAP_POSITIVEY   = $00001000;
  DDSCAPS2_CUBEMAP_NEGATIVEY   = $00002000;
  DDSCAPS2_CUBEMAP_POSITIVEZ   = $00004000;
  DDSCAPS2_CUBEMAP_NEGATIVEZ   = $00008000;

  DDSCAPS2_CUBEMAP_ALLFACES    =
    DDSCAPS2_CUBEMAP_POSITIVEX or DDSCAPS2_CUBEMAP_NEGATIVEX or
    DDSCAPS2_CUBEMAP_POSITIVEY or DDSCAPS2_CUBEMAP_NEGATIVEY or
    DDSCAPS2_CUBEMAP_POSITIVEZ or DDSCAPS2_CUBEMAP_NEGATIVEZ;

  DDSCAPS2_MIPMAPSUBLEVEL      = $00010000;
  DDSCAPS2_D3DTEXTUREMANAGE    = $00020000;
  DDSCAPS2_DONOTPERSIST        = $00040000;
  DDSCAPS2_STEREOSURFACELEFT   = $00080000;

{ TDDOptSurfaceDesc flags }

  DDOSD_GUID              = $00000001;
  DDOSD_COMPRESSION_RATIO = $00000002;
  DDOSD_SCAPS             = $00000004;
  DDOSD_OSCAPS            = $00000008;
  DDOSD_ALL               = $0000000F;

{ ddOSCaps field is valid. }

  DDOSDCAPS_OPTCOMPRESSED    = $00000001;
  DDOSDCAPS_OPTREORDERED     = $00000002;
  DDOSDCAPS_MONOLITHICMIPMAP = $00000004;
  DDOSDCAPS_VALIDSCAPS       = $30004800;
  DDOSDCAPS_VALIDOSCAPS      = $00000007;

{ DirectDraw FX Alpha Capability Flags }

  DDFXALPHACAPS_BLTALPHAEDGEBLEND         = $00000001;
  DDFXALPHACAPS_BLTALPHAPIXELS            = $00000002;
  DDFXALPHACAPS_BLTALPHAPIXELSNEG         = $00000004;
  DDFXALPHACAPS_BLTALPHASURFACES          = $00000008;
  DDFXALPHACAPS_BLTALPHASURFACESNEG       = $00000010;
  DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND     = $00000020;
  DDFXALPHACAPS_OVERLAYALPHAPIXELS        = $00000040;
  DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG     = $00000080;
  DDFXALPHACAPS_OVERLAYALPHASURFACES      = $00000100;
  DDFXALPHACAPS_OVERLAYALPHASURFACESNEG   = $00000200;

{ DirectDraw FX Capability Flags }

  DDFXCAPS_BLTARITHSTRETCHY       = $00000020;
  DDFXCAPS_BLTARITHSTRETCHYN      = $00000010;
  DDFXCAPS_BLTMIRRORLEFTRIGHT     = $00000040;
  DDFXCAPS_BLTMIRRORUPDOWN        = $00000080;
  DDFXCAPS_BLTROTATION            = $00000100;
  DDFXCAPS_BLTROTATION90          = $00000200;
  DDFXCAPS_BLTSHRINKX             = $00000400;
  DDFXCAPS_BLTSHRINKXN            = $00000800;
  DDFXCAPS_BLTSHRINKY             = $00001000;
  DDFXCAPS_BLTSHRINKYN            = $00002000;
  DDFXCAPS_BLTSTRETCHX            = $00004000;
  DDFXCAPS_BLTSTRETCHXN           = $00008000;
  DDFXCAPS_BLTSTRETCHY            = $00010000;
  DDFXCAPS_BLTSTRETCHYN           = $00020000;
  DDFXCAPS_OVERLAYARITHSTRETCHY   = $00040000;
  DDFXCAPS_OVERLAYARITHSTRETCHYN  = $00000008;
  DDFXCAPS_OVERLAYSHRINKX         = $00080000;
  DDFXCAPS_OVERLAYSHRINKXN        = $00100000;
  DDFXCAPS_OVERLAYSHRINKY         = $00200000;
  DDFXCAPS_OVERLAYSHRINKYN        = $00400000;
  DDFXCAPS_OVERLAYSTRETCHX        = $00800000;
  DDFXCAPS_OVERLAYSTRETCHXN       = $01000000;
  DDFXCAPS_OVERLAYSTRETCHY        = $02000000;
  DDFXCAPS_OVERLAYSTRETCHYN       = $04000000;
  DDFXCAPS_OVERLAYMIRRORLEFTRIGHT = $08000000;
  DDFXCAPS_OVERLAYMIRRORUPDOWN    = $10000000;
  DDFXCAPS_BLTALPHA               = $00000001;
  DDFXCAPS_BLTTRANSFORM           = $00000002;
  DDFXCAPS_BLTFILTER              = DDFXCAPS_BLTARITHSTRETCHY;
  DDFXCAPS_OVERLAYALPHA           = $00000004;
  DDFXCAPS_OVERLAYTRANSFORM       = $20000000;
  DDFXCAPS_OVERLAYFILTER          = DDFXCAPS_OVERLAYARITHSTRETCHY;

{ DirectDraw Stereo View Capabilities }

  DDSVCAPS_RESERVED1              = $00000001;
  DDSVCAPS_RESERVED2              = $00000002;
  DDSVCAPS_RESERVED3              = $00000004;
  DDSVCAPS_RESERVED4              = $00000008;
  DDSVCAPS_STEREOSEQUENTIAL       = $00000010;

{ DirectDrawPalette Capabilities }

  DDPCAPS_4BIT               = $00000001;
  DDPCAPS_8BITENTRIES        = $00000002;
  DDPCAPS_8BIT               = $00000004;
  DDPCAPS_INITIALIZE         = $00000008;
  DDPCAPS_PRIMARYSURFACE     = $00000010;
  DDPCAPS_PRIMARYSURFACELEFT = $00000020;
  DDPCAPS_ALLOW256           = $00000040;
  DDPCAPS_VSYNC              = $00000080;
  DDPCAPS_1BIT               = $00000100;
  DDPCAPS_2BIT               = $00000200;
  DDPCAPS_ALPHA              = $00000400;

{ DirectDraw BitDepth Constants }

  DDBD_1  = $00004000;
  DDBD_2  = $00002000;
  DDBD_4  = $00001000;
  DDBD_8  = $00000800;
  DDBD_16 = $00000400;
  DDBD_24 = $00000200;
  DDBD_32 = $00000100;

{ DirectDraw Set/Get Color Key Flags }

  DDCKEY_COLORSPACE  = $00000001;
  DDCKEY_DESTBLT     = $00000002;
  DDCKEY_DESTOVERLAY = $00000004;
  DDCKEY_SRCBLT      = $00000008;
  DDCKEY_SRCOVERLAY  = $00000010;

{ DirectDraw Color Key Capability Flags }

  DDCKEYCAPS_DESTBLT                = $00000001;
  DDCKEYCAPS_DESTBLTCLRSPACE        = $00000002;
  DDCKEYCAPS_DESTBLTCLRSPACEYUV     = $00000004;
  DDCKEYCAPS_DESTBLTYUV             = $00000008;
  DDCKEYCAPS_DESTOVERLAY            = $00000010;
  DDCKEYCAPS_DESTOVERLAYCLRSPACE    = $00000020;
  DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV = $00000040;
  DDCKEYCAPS_DESTOVERLAYONEACTIVE   = $00000080;
  DDCKEYCAPS_DESTOVERLAYYUV         = $00000100;
  DDCKEYCAPS_SRCBLT                 = $00000200;
  DDCKEYCAPS_SRCBLTCLRSPACE         = $00000400;
  DDCKEYCAPS_SRCBLTCLRSPACEYUV      = $00000800;
  DDCKEYCAPS_SRCBLTYUV              = $00001000;
  DDCKEYCAPS_SRCOVERLAY             = $00002000;
  DDCKEYCAPS_SRCOVERLAYCLRSPACE     = $00004000;
  DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV  = $00008000;
  DDCKEYCAPS_SRCOVERLAYONEACTIVE    = $00010000;
  DDCKEYCAPS_SRCOVERLAYYUV          = $00020000;
  DDCKEYCAPS_NOCOSTOVERLAY          = $00040000;

{ DirectDraw PixelFormat Flags }

  DDPF_ALPHAPIXELS       = $00000001;
  DDPF_ALPHA             = $00000002;
  DDPF_FOURCC            = $00000004;
  DDPF_PALETTEINDEXED4   = $00000008;
  DDPF_PALETTEINDEXEDTO8 = $00000010;
  DDPF_PALETTEINDEXED8   = $00000020;
  DDPF_RGB               = $00000040;
  DDPF_COMPRESSED        = $00000080;
  DDPF_RGBTOYUV          = $00000100;
  DDPF_YUV               = $00000200;
  DDPF_ZBUFFER           = $00000400;
  DDPF_PALETTEINDEXED1   = $00000800;
  DDPF_PALETTEINDEXED2   = $00001000;
  DDPF_ZPIXELS           = $00002000;
  DDPF_STENCILBUFFER     = $00004000;
  DDPF_ALPHAPREMULT      = $00008000;
  DDPF_LUMINANCE         = $00020000;
  DDPF_BUMPLUMINANCE     = $00040000;
  DDPF_BUMPDUDV          = $00080000;

{ DirectDraw SetDisplayMode Flags }

  DDSDM_STANDARDVGAMODE  = $00000001;

{ DirectDraw EnumDisplayModes Flags }

  DDEDM_REFRESHRATES     = $00000001;
  DDEDM_STANDARDVGAMODES = $00000002;

{ DirectDraw EnumSurfaces Flags }

  DDENUMSURFACES_ALL           = $00000001;
  DDENUMSURFACES_MATCH         = $00000002;
  DDENUMSURFACES_NOMATCH       = $00000004;
  DDENUMSURFACES_CANBECREATED  = $00000008;
  DDENUMSURFACES_DOESEXIST     = $00000010;

{ DirectDraw SetCooperativeLevel Flags }

  DDSCL_FULLSCREEN          = $00000001;
  DDSCL_ALLOWREBOOT         = $00000002;
  DDSCL_NOWINDOWCHANGES     = $00000004;
  DDSCL_NORMAL              = $00000008;
  DDSCL_EXCLUSIVE           = $00000010;
  DDSCL_ALLOWMODEX          = $00000040;
  DDSCL_SETFOCUSWINDOW      = $00000080;
  DDSCL_SETDEVICEWINDOW     = $00000100;
  DDSCL_CREATEDEVICEWINDOW  = $00000200;
  DDSCL_MULTITHREADED       = $00000400;
  DDSCL_FPUSETUP            = $00000800;
  DDSCL_FPUPRESERVE         = $00001000;

{ DirectDraw Blt Flags }

  DDBLT_ALPHADEST                = $00000001;
  DDBLT_ALPHADESTCONSTOVERRIDE   = $00000002;
  DDBLT_ALPHADESTNEG             = $00000004;
  DDBLT_ALPHADESTSURFACEOVERRIDE = $00000008;
  DDBLT_ALPHAEDGEBLEND           = $00000010;
  DDBLT_ALPHASRC                 = $00000020;
  DDBLT_ALPHASRCCONSTOVERRIDE    = $00000040;
  DDBLT_ALPHASRCNEG              = $00000080;
  DDBLT_ALPHASRCSURFACEOVERRIDE  = $00000100;
  DDBLT_ASYNC                    = $00000200;
  DDBLT_COLORFILL                = $00000400;
  DDBLT_DDFX                     = $00000800;
  DDBLT_DDROPS                   = $00001000;
  DDBLT_KEYDEST                  = $00002000;
  DDBLT_KEYDESTOVERRIDE          = $00004000;
  DDBLT_KEYSRC                   = $00008000;
  DDBLT_KEYSRCOVERRIDE           = $00010000;
  DDBLT_ROP                      = $00020000;
  DDBLT_ROTATIONANGLE            = $00040000;
  DDBLT_ZBUFFER                  = $00080000;
  DDBLT_ZBUFFERDESTCONSTOVERRIDE = $00100000;
  DDBLT_ZBUFFERDESTOVERRIDE      = $00200000;
  DDBLT_ZBUFFERSRCCONSTOVERRIDE  = $00400000;
  DDBLT_ZBUFFERSRCOVERRIDE       = $00800000;
  DDBLT_WAIT                     = $01000000;
  DDBLT_DEPTHFILL                = $02000000;
  DDBLT_DONOTWAIT                = $08000000;

{ BltFast Flags }

  DDBLTFAST_NOCOLORKEY   = $00000000;
  DDBLTFAST_SRCCOLORKEY  = $00000001;
  DDBLTFAST_DESTCOLORKEY = $00000002;
  DDBLTFAST_WAIT         = $00000010;
  DDBLTFAST_DONOTWAIT    = $00000020;

{ Flip Flags }

  DDFLIP_WAIT      = $00000001;
  DDFLIP_EVEN      = $00000002;
  DDFLIP_ODD       = $00000004;
  DDFLIP_NOVSYNC   = $00000008;
  DDFLIP_INTERVAL2 = $02000000;
  DDFLIP_INTERVAL3 = $03000000;
  DDFLIP_INTERVAL4 = $04000000;
  DDFLIP_STEREO    = $00000010;
  DDFLIP_DONOTWAIT = $00000020;

{ DirectDraw Surface Overlay Flags }

  DDOVER_ALPHADEST                = $00000001;
  DDOVER_ALPHADESTCONSTOVERRIDE   = $00000002;
  DDOVER_ALPHADESTNEG             = $00000004;
  DDOVER_ALPHADESTSURFACEOVERRIDE = $00000008;
  DDOVER_ALPHAEDGEBLEND           = $00000010;
  DDOVER_ALPHASRC                 = $00000020;
  DDOVER_ALPHASRCCONSTOVERRIDE    = $00000040;
  DDOVER_ALPHASRCNEG              = $00000080;
  DDOVER_ALPHASRCSURFACEOVERRIDE  = $00000100;
  DDOVER_HIDE                     = $00000200;
  DDOVER_KEYDEST                  = $00000400;
  DDOVER_KEYDESTOVERRIDE          = $00000800;
  DDOVER_KEYSRC                   = $00001000;
  DDOVER_KEYSRCOVERRIDE           = $00002000;
  DDOVER_SHOW                     = $00004000;
  DDOVER_ADDDIRTYRECT             = $00008000;
  DDOVER_REFRESHDIRTYRECTS        = $00010000;
  DDOVER_REFRESHALL               = $00020000;
  DDOVER_DDFX                     = $00080000;
  DDOVER_AUTOFLIP                 = $00100000;
  DDOVER_BOB                      = $00200000;
  DDOVER_OVERRIDEBOBWEAVE         = $00400000;
  DDOVER_INTERLEAVED              = $00800000;
  DDOVER_BOBHARDWARE              = $01000000;
  DDOVER_ARGBSCALEFACTORS         = $02000000;
  DDOVER_DEGRADEARGBSCALING       = $04000000;

{ DirectDrawSurface Lock Flags }

  DDLOCK_SURFACEMEMORYPTR  = $00000000;    // default
  DDLOCK_WAIT              = $00000001;
  DDLOCK_EVENT             = $00000002;
  DDLOCK_READONLY          = $00000010;
  DDLOCK_WRITEONLY         = $00000020;
  DDLOCK_NOSYSLOCK         = $00000800;
  DDLOCK_NOOVERWRITE       = $00001000;
  DDLOCK_DISCARDCONTENTS   = $00002000;
  DDLOCK_OKTOSWAP          = $00002000;
  DDLOCK_DONOTWAIT         = $00004000;

{ DirectDrawSurface Blt FX Flags }

  DDBLTFX_ARITHSTRETCHY    = $00000001;
  DDBLTFX_MIRRORLEFTRIGHT  = $00000002;
  DDBLTFX_MIRRORUPDOWN     = $00000004;
  DDBLTFX_NOTEARING        = $00000008;
  DDBLTFX_ROTATE180        = $00000010;
  DDBLTFX_ROTATE270        = $00000020;
  DDBLTFX_ROTATE90         = $00000040;
  DDBLTFX_ZBUFFERRANGE     = $00000080;
  DDBLTFX_ZBUFFERBASEDEST  = $00000100;

{ DirectDrawSurface Overlay FX Flags }

  DDOVERFX_ARITHSTRETCHY   = $00000001;
  DDOVERFX_MIRRORLEFTRIGHT = $00000002;
  DDOVERFX_MIRRORUPDOWN    = $00000004;

{ Flags for dwDDFX member of DDSPRITEFX structure }

  DDSPRITEFX_AFFINETRANSFORM    = $00000001;
  DDSPRITEFX_RGBASCALING        = $00000002;
  DDSPRITEFX_DEGRADERGBASCALING = $00000004;
  DDSPRITEFX_BILINEARFILTER     = $00000008;
  DDSPRITEFX_BLURFILTER         = $00000010;
  DDSPRITEFX_FLATFILTER         = $00000020;
  DDSPRITEFX_DEGRADEFILTER      = $00000040;

{ DirectDraw WaitForVerticalBlank Flags }

  DDWAITVB_BLOCKBEGIN      = $00000001;
  DDWAITVB_BLOCKBEGINEVENT = $00000002;
  DDWAITVB_BLOCKEND        = $00000004;

{ DirectDraw GetFlipStatus Flags }

  DDGFS_CANFLIP    = $00000001;
  DDGFS_ISFLIPDONE = $00000002;

{ DirectDraw GetBltStatus Flags }

  DDGBS_CANBLT     = $00000001;
  DDGBS_ISBLTDONE  = $00000002;

{ DirectDraw EnumOverlayZOrder Flags }

  DDENUMOVERLAYZ_BACKTOFRONT = $00000000;
  DDENUMOVERLAYZ_FRONTTOBACK = $00000001;

{ DirectDraw UpdateOverlayZOrder Flags }

  DDOVERZ_SENDTOFRONT     = $00000000;
  DDOVERZ_SENDTOBACK      = $00000001;
  DDOVERZ_MOVEFORWARD     = $00000002;
  DDOVERZ_MOVEBACKWARD    = $00000003;
  DDOVERZ_INSERTINFRONTOF = $00000004;
  DDOVERZ_INSERTINBACKOF  = $00000005;

function DirectDrawCreate(lpGUID: PGUID; out lplpDD: IDirectDraw;
  pUnkOuter: IUnknown): HResult; stdcall;
function DirectDrawCreateEx(lpGUID: PGUID; out lplpDD; const iid: TGUID;
  pUnkOuter: IUnknown): HResult; stdcall;
function DirectDrawCreateClipper(dwFlags: DWORD; out lplpDDClipper: IDirectDrawClipper;
  pUnkOuter: IUnknown): HResult; stdcall;

implementation

const
  DDrawLib = 'DDraw.dll';

{ DirectDraw }


function DirectDrawCreate; external DDrawLib;
function DirectDrawCreateEx; external DDrawLib;
function DirectDrawCreateClipper; external DDrawLib;


end.



